// Init

$(document).ready(function() {
	registerJSFunction('updateNoteInfo', updateNoteInfo);
	registerJSFunction('updateBirthDay', updateBirthDay);
	registerJSFunction('doMainMenuAction', doMainMenuAction);
	registerJSFunction('setFocus', setFocus);
	initPage();
	initLanguage();
});

function doMainMenuAction(params) {
	function getPanel() {
		var panel = document.getElementById("view_panel");
		if (!$(panel).hasClass('hide')) return panel;

		panel = document.getElementById("group_panel_view");
		if (!$(panel).hasClass('hide')) return panel;

		panel = document.getElementById("edit_panel");
		if (!$(panel).hasClass('hide')) return panel;

		panel = document.getElementById("group_panel_edit");
		if (!$(panel).hasClass('hide')) return panel;

		return null;
	}
	try {
		var action = params.getValue('action');
		if (action === "SelectAll") {
			var range = document.body.createTextRange();
			var panel = getPanel();
			if (panel !== null )
				range.moveToElementText(panel);
			range.select();
		} else if(action === "copy") {
			var selectedText;
			if (window.getSelection) {
				selectedText = window.getSelection();
			} else if (document.selection) {
				selectedText = document.selection.createRange().text;
			}
			if (window.clipboardData) {
				window.clipboardData.setData("Text", selectedText);
			}
		}
	} catch (e) {
		WriteLog('doMainMenuAction', e.message);
	}
}

function initLanguage() {
	$('.desc_mobile').text(csMobile);
	// $('.desc_country').text(csCountry);
	// $('.desc_province').text(csProvince);
	// $('.desc_city').text(csCity);
	// $('.desc_street').text(csStreet);
	// $('.desc_post_code').text(csPostCode);
	$('.desc_other_info').text(csOtherInfo);
	$('.desc_mail_group').text(csMailGroup);
	$('.desc_display_name').text(csDisplayName);
	$('.desc_sex').text(csSex);
	$('.desc_nick').text(csNick);
	$('.desc_birthday').text(csBirthday);
	$('.desc_qq').text(csQQ);
	$('.desc_home_page').text(csHomePage);
	$('.desc_home_address').text(csHomeAddress);
	$('.desc_company').text(csCompany);
	$('.desc_dept').text(csDept);
	$('.desc_position').text(csPosition);
	$('.desc_company_address').text(csCompanyAddress);
	$('.desc_mail_address').text(csMailAddress);
	$('.desc_fax_1').text(csFax1);
	$('.desc_fax_2').text(csFax2);
	$('.desc_phone_1').text(csPhone1);
	$('.desc_phone_2').text(csPhone2);
	$('.desc_phone_3').text(csPhone3);
	$('.desc_phone_4').text(csPhone4);
	$('.desc_phone_5').text(csPhone5);
	$('.desc_save').text(csSave);
	$('.desc_cancel').text(csCancel);
	$('.desc_delete_contact').text(csDelete);
	$('.desc_add_member').text(csAddMember);
	$('.desc_delete_group').text(csDeleteGroup);
}

// Private Function

function checkDateTime(dateStr) {
	var parts;
	if (dateStr.indexOf("-") > -1) {
		parts = dateStr.split('-');
		if (parts.length == 3) {
			for (i = 0; i < 3; i++) {
				//如果构成日期的某个部分不是数字，则返回false
				if (isNaN(parts[i])) {
					return false;
				}
			}
			var y = parts[0];
			//年
			var m = parts[1];
			//月
			var d = parts[2];
			//日
			//暂时简单判断 闰年的先不处理
			if (y <= 3000 && m >= 1 && m <= 12 && d >= 1 && d <= 31) {
				return true;
			}
		}
	}
	return false;
}

//
// 显示联系人资料卡
//
function ToggleContactCard(el, flag) {
	try {
		if ((el != undefined) && (el.length != 0) && flag) {
			var noteid = el.attr('noteid');
			var px = el.offset().left;
			var py = el.offset().top + el.height();
			invokeAppFunction('PopupContactCard', {
				noteid: noteid,
				x: px,
				y: py,
				show: true
			});	
		} else {
			invokeAppFunction('PopupContactCard', {
				noteid: 0,
				x: 0,
				y: 0,
				show: false
			});
		}
	} catch (e) {
		WriteLog('ToggleContactCard', e.message);
	}
}

//
// 显示与隐藏日历选择控件
//
function ToggleBirthdayCalendar(flag) {
	try {
		var button = $('#birthday_button');

		if (flag) {
			button.removeClass('calendar_button_normal');
			button.addClass('calendar_button_press');

			var editor = $('#birthday_editor');
			editor.foxEditor().focus();

			var toolbar = $('#toolbar');
			scrollPanel(editor, toolbar, 5, 195);

			var px = button.offset().left;
			var py = button.offset().top;
			invokeAppFunction('PopupCalendar', {
				x: px,
				y: py,
				show: true
			});
		} else {
			button.removeClass('calendar_button_press');
			button.addClass('calendar_button_normal');

			$('#birthday_editor').foxEditor().blur();

			invokeAppFunction('PopupCalendar', {
				x: 0,
				y: 0,
				show: false
			});
		}
	} catch (e) {
		WriteLog('ToggleBirthdayCalendar', e.message);
	}
}

function showEditPanel(visible) {
	// $('#main').show();
	var editPanel = $('.edit_panel');
	if (visible) {
		$('#toolbar').show();
		$('#info_buttons').show();
		$('#group_buttons').hide();
		if (editPanel.hasClass('hide')) editPanel.removeClass('hide');
		var editor = $('#last_name').foxEditor();
		editor.setFocus();
		editor.setValue(editor.getValue());
	} else {
		$('#contact_list').empty();
		$('#contact_list').attr('phoneNum', '0');
		$('#contact_list').attr('faxNum', '0');
		if (!editPanel.hasClass('hide')) editPanel.addClass('hide');
	}
	updateScrollbar();
}

function showViewPanel(visible) {
	// $('#main').show();
	var viewPanel = $('.view_panel');
	if (visible) {
		$('#toolbar').hide();
		if (viewPanel.hasClass('hide')) viewPanel.removeClass('hide');
	} else {
		if (!viewPanel.hasClass('hide')) viewPanel.addClass('hide');
	}
	updateScrollbar();
}

function showGroupViewPanel(visible) {
	// $('#main').show();
	var groupPanel = $('#group_panel');
	var groupViewPanel = $('#group_panel_view');
	if (visible) {
		$('#toolbar').hide();
		groupPanel.removeClass('hide');
		groupViewPanel.removeClass('hide');
	} else {
		groupPanel.addClass('hide');
		groupViewPanel.addClass('hide');
	}
	updateScrollbar();
}

function showGroupEditPanel(visible) {
	// $('#main').show();
	var groupPanel = $('#group_panel');
	var groupEditPanel = $('#group_panel_edit');
	if (visible) {
		$('#toolbar').show();
		$('#info_buttons').hide();
		$('#group_buttons').show();
		groupPanel.removeClass('hide');
		groupEditPanel.removeClass('hide');
		var editor = $('#group_edit_name').foxEditor();
		editor.setFocus();
		editor.setValue(editor.getValue());
	} else {
		groupEditPanel.addClass('hide');
	}
	updateScrollbar();
}

function updateScrollbar() {
	var scrollbar = getFoxWBScrollbar('scrollbar');
	if (scrollbar) {
		scrollbar.update();
	}
}

//
// 向邮件列表中添加编辑框
//

function AddEmailAddressEditor(email, bPlus, bFocus, bSlide) {
	var editorHtml =
		"<div class='foxMailAddrEditor blur'>\
			<div class='border-top border-top-background'></div>\
			<div class='border-top-left border-top-left-background'></div>\
			<div class='border-top-right border-top-right-background'></div>\
			<div class='border-left border-left-background'></div>\
			<div class='border-right border-right-background'></div>\
			<div class='mail-icon'></div>\
			<input/>\
			<div class='border-bottom border-bottom-background'></div>\
			<div class='border-bottom-left border-bottom-left-background'></div>\
			<div class='border-bottom-right border-bottom-right-background'></div>\
		</div>";
	var plusButtonHtml =
		"<div class='plus_button email_list_plus_button' name='add_email_address'>\
		</div>";
	var minButtonHtml =
		"<div class='minus_button email_list_minus_button' name='remove_email_address'>\
		</div>";

	var cls = '';
	if (bSlide) cls = 'hide';
	var li = $("<li class='" + cls + "'>" + editorHtml + "</li>");

	var btn = null;
	if (bPlus) btn = $("<li class='" + cls + "'>" + plusButtonHtml + "</li>");
	else btn = $("<li class='" + cls + "'>" + minButtonHtml + "</li>");

	var emailList = $('#email_list_editors ul');
	var btnList = $('#email_list_buttons ul');
	li.appendTo(emailList);
	btn.appendTo(btnList);

	if (bSlide) {
		li.slideDown('fast', function() {
			if (bFocus) li.find('input').focus();
			updateScrollbar();
		});
		btn.slideDown('fast', function() {
			updateScrollbar();
		});
	}

	var editor = li.find('.foxMailAddrEditor').foxMailAddrEditor();
	editor.setValue(email);
	editor.onFocus(function() {
		$('#email_list_editors ul').enableSelection();
	});
}

function DoRemoveEmailAddressItem(curItem) {
	var editors = $('#email_list_editors li');
	var index = $('#email_list_buttons li').index(curItem);
	var editor = $(editors[index]);
	editor.slideUp('fast', function() {
		editor.remove();
		updateScrollbar();
	});
	curItem.slideUp('fast', function() {
		curItem.remove();
		updateScrollbar();
	});
}

//
// 增加手机号码编辑框
//

function AddMobileEditor(mobileValue) {
	var list = $('#contact_list');

	var descHtml = "<div class='editor_desc desc_mobile'>" + csMobile + "</div>";
	var editorHtml =
		"<div class='foxEditor blur mobile_editor'>\
			<div class='border-top border-top-background'></div>\
			<div class='border-top-left border-top-left-background'></div>\
			<div class='border-top-right border-top-right-background'></div>\
			<div class='border-left border-left-background'></div>\
			<div class='border-right border-right-background'></div>\
			<input/>\
			<div class='border-bottom border-bottom-background'></div>\
			<div class='border-bottom-left border-bottom-left-background'></div>\
			<div class='border-bottom-right border-bottom-right-background'></div>\
		</div>";
	var liHtml = liHtml = "<li>" + descHtml + editorHtml + "<div class='clear'></div></li>";

	var elLi = $(liHtml);
	var mobileEditor = elLi.find('.foxEditor').foxEditor();
	mobileEditor.setValue(mobileValue);
	elLi.appendTo(list);
}

//
// 增加联系电话编辑框
//

function AddPhoneEditor(phoneValue, bFocus, callback, bSlide) {
	var list = $('#contact_list');
	var num = parseInt(list.attr('phoneNum')) + 1;
	if (num > 5) return false;
	list.attr('phoneNum', num);

	var descHtml = "<div class='editor_desc desc_mobile'>" + csPhone + num + "</div>";
	var editorHtml =
		"<div class='foxEditor blur phone_editor'>\
			<div class='border-top border-top-background'></div>\
			<div class='border-top-left border-top-left-background'></div>\
			<div class='border-top-right border-top-right-background'></div>\
			<div class='border-left border-left-background'></div>\
			<div class='border-right border-right-background'></div>\
			<input/>\
			<div class='border-bottom border-bottom-background'></div>\
			<div class='border-bottom-left border-bottom-left-background'></div>\
			<div class='border-bottom-right border-bottom-right-background'></div>\
		</div>";
	var plusButtonHtml =
		"<div class='plus_button contact_list_button' name='add_contact_phone'>\
		</div>";
	var minButtonHtml =
		"<div class='minus_button contact_list_button' name='remove_contact_phone'>\
		</div>";
	var hide = '';
	if (bSlide) hide = 'hide';
	var liHtml = "";
	if (num === 1) liHtml = "<li class='" + hide + "'>" + descHtml + editorHtml + plusButtonHtml + "<div class='clear'></div></li>";
	else liHtml = "<li class='" + hide + "'>" + descHtml + editorHtml + minButtonHtml + "<div class='clear'></div></li>";

	var elLi = $(liHtml);
	var phoneEditor = elLi.find('.foxEditor').foxEditor();
	phoneEditor.setValue(phoneValue);

	var target = $(list.find('li').get(num - 1));
	elLi.insertAfter(target);

	if (bSlide) {
		elLi.slideDown('fast', function() {
			updateScrollbar();
			if (bFocus) {
				if (bFocus) elLi.find('input').focus();
			}
			if (callback) {
				callback();
			}
		});
	}
}

//
// 删除联系电话编辑框
//

function DoRemoveContactPhoneItem(curItem, callback) {
	curItem.slideUp('fast', function() {
		var list = $('#contact_list');
		var num = parseInt(list.attr('phoneNum')) - 1;
		list.attr('phoneNum', num);
		curItem.remove();
		//fix
		var li = $($('li', list).get(0));
		for (var i = 0; i < num; i++) {
			li = li.next();
			var desc = $('.contact_list_li_desc', li);
			desc.text(csPhone + (i + 1));
		}
		//
		updateScrollbar();
		if (callback) {
			callback();
		}
	});
}

function CheckAddPhoneButton() {
	var list = $('#contact_list');
	var num = parseInt(list.attr('phoneNum'));
	var obj = $($('.contact_list_button', list)[0]);
	if (num == 5) {
		//隐藏添加按钮
		obj.hide();
	} else {
		//显示添加按钮
		obj.show();
	}
}

function CheckAddFaxButton() {
	var list = $('#contact_list');
	var num = parseInt(list.attr('faxNum'));
	var liElements = $('.contact_list_button', list);
	var index = liElements.length - num;
	var obj = $(liElements.get(index));
	if (num == 2) {
		//隐藏添加按钮
		obj.hide();
	} else {
		//显示添加按钮
		obj.show();
	}
}

//
// 增加传真编辑框
//

function AddFaxEditor(phoneValue, bFocus, callback, bSlide) {
	var list = $('#contact_list');
	var num = parseInt(list.attr('faxNum')) + 1;
	if (num > 2) return false;
	list.attr('faxNum', num);

	var descHtml = "<div class='editor_desc desc_mobile'>" + csFax + num + "</div>";
	var editorHtml =
		"<div class='foxEditor blur fax_editor'>\
			<div class='border-top border-top-background'></div>\
			<div class='border-top-left border-top-left-background'></div>\
			<div class='border-top-right border-top-right-background'></div>\
			<div class='border-left border-left-background'></div>\
			<div class='border-right border-right-background'></div>\
			<input/>\
			<div class='border-bottom border-bottom-background'></div>\
			<div class='border-bottom-left border-bottom-left-background'></div>\
			<div class='border-bottom-right border-bottom-right-background'></div>\
		</div>";
	var plusButtonHtml =
		"<div class='plus_button contact_list_button' name='add_contact_fax'>\
		</div>";
	var minButtonHtml =
		"<div class='minus_button contact_list_button' name='remove_contact_fax'>\
		</div>";
	var hide = '';
	if (bSlide) hide = 'hide';
	var liHtml = "";
	if (num === 1) liHtml = "<li class='" + hide + "'>" + descHtml + editorHtml + plusButtonHtml + "<div class='clear'></div></li>";
	else liHtml = "<li class='" + hide + "'>" + descHtml + editorHtml + minButtonHtml + "<div class='clear'></div></li>";

	var elLi = $(liHtml);
	var phoneEditor = elLi.find('.foxEditor').foxEditor();
	phoneEditor.setValue(phoneValue);

	num += parseInt(list.attr('phoneNum'));
	var target = $(list.find('li').get(num - 1));
	elLi.insertAfter(target);

	if (bSlide) {
		elLi.slideDown('fast', function() {
			updateScrollbar();
			if (bFocus) {
				if (bFocus) elLi.find('input').focus();
			}
			if (callback) {
				callback();
			}
		});
	}
}

function DoRemoveContactFaxItem(curItem, callback) {
	curItem.slideUp('fast', function() {
		var list = $('#contact_list');
		var num = parseInt(list.attr('faxNum')) - 1;
		list.attr('faxNum', num);
		curItem.remove();
		updateScrollbar();
		if (callback) {
			callback();
		}
	});
}

var g_curAddrNoteInfo = {};
var g_isNew = false;

function doNewAddrNote() {
	try {
		g_isNew = true;
		g_curAddrNoteInfo = null;
		g_curAddrNoteInfo = {};
		g_curAddrNoteInfo.avatar = invokeAppFunction('GetDefaultAvatar', {});
		g_curAddrNoteInfo.firstName = '';
		g_curAddrNoteInfo.lastName = '';
		g_curAddrNoteInfo.displayName = '';
		g_curAddrNoteInfo.mainEmail = '';
		g_curAddrNoteInfo.emailList = [];
		g_curAddrNoteInfo.mobile = '';
		g_curAddrNoteInfo.phoneList = [];
		g_curAddrNoteInfo.faxList = [];
		g_curAddrNoteInfo.nickName = '';
		g_curAddrNoteInfo.birthday = '';
		g_curAddrNoteInfo.sex = 0;
		g_curAddrNoteInfo.qq = '';
		g_curAddrNoteInfo.personalHomePage = '';
		g_curAddrNoteInfo.personalCountry = '';
		g_curAddrNoteInfo.personalProvince = '';
		g_curAddrNoteInfo.personalCity = '';
		g_curAddrNoteInfo.personalStreet = '';
		g_curAddrNoteInfo.personalPostCode = '';

		g_curAddrNoteInfo.companyName = '';
		g_curAddrNoteInfo.companyDept = '';
		g_curAddrNoteInfo.companyPosition = '';
		g_curAddrNoteInfo.companyCountry = '';
		g_curAddrNoteInfo.companyProvince = '';
		g_curAddrNoteInfo.companyCity = '';
		g_curAddrNoteInfo.companyStreet = '';
		g_curAddrNoteInfo.companyPostCode = '';
		g_curAddrNoteInfo.otherInfo = '';
	} catch (e) {
		WriteLog('doNewAddrNote', e.message);
	}
}

function syncGroupInfo() {
	g_curAddrNoteInfo = null;
	g_curAddrNoteInfo = {};
	g_curAddrNoteInfo.groupName = $('#group_edit_name').foxEditor().getValue();
	g_curAddrNoteInfo.groupList = [];
	var container = $('#group_list_container');
	var members = $('input', container);
	for (var i = 0; i < members.length; i++) {
		var obj = $(members[i]);
		var noteId = obj.attr('noteId');
		var type = obj.attr('noteType');
		var name = obj.val();
		g_curAddrNoteInfo.groupList[g_curAddrNoteInfo.groupList.length] = {
			id: noteId,
			type: type,
			name: name
		};
	}
}

function syncNoteInfo() {
	//update g_curAddrNoteInfo
	//base info

	//
	// 获取姓、名、显示名称
	//
	g_curAddrNoteInfo.firstName = $('#first_name').foxEditor().getValue();
	g_curAddrNoteInfo.lastName = $('#last_name').foxEditor().getValue();
	g_curAddrNoteInfo.displayName = $('#switch_display_name').foxListSelector().getValue();

	//email list
	g_curAddrNoteInfo.emailList = [];
	var emailEditors = $('#email_list_editors .foxMailAddrEditor');
	var i = 0;
	emailEditors.each(function() {
		var value = $(this).foxMailAddrEditor().getValue();
		if (value !== '') g_curAddrNoteInfo.emailList[i++] = value;
	});
	// for (var i = 0; i < emailEditors.length; i++) {
	// 	var value = $(emailEditors[i]).foxMailAddrEditor().getValue();
	// 	if (value !== '') g_curAddrNoteInfo.emailList[i] = value;
	// }

	// 移动号码
	var elContactList = $('#contact_list');
	g_curAddrNoteInfo.mobile = elContactList.find('.mobile_editor').foxEditor().getValue();

	// 电话号码
	g_curAddrNoteInfo.phoneList = [];
	var elPhones = elContactList.find('.phone_editor');
	for (var i = 0; i < elPhones.length; i++) {
		g_curAddrNoteInfo.phoneList[i] = $(elPhones[i]).foxEditor().getValue();
	};

	// 传真
	var elFaxes = elContactList.find('.fax_editor');
	g_curAddrNoteInfo.faxList = [];
	for (var i = 0; i < elFaxes.length; i++) {
		g_curAddrNoteInfo.faxList[i] = $(elFaxes[i]).foxEditor().getValue();
	};

	//personal profile
	var strBirthday = $('#birthday_editor').foxEditor().getValue();
	g_curAddrNoteInfo.birthday = checkDateTime(strBirthday) ? strBirthday : '';
	g_curAddrNoteInfo.nickName = $('#nick_name').foxEditor().getValue();
	g_curAddrNoteInfo.sex = getSexValue($('#sex_editor').foxCombobox().getValue());
	g_curAddrNoteInfo.qq = $('#qq_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalHomePage = $('#homepage_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalCountry = $('#family_country_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalProvince = $('#family_province_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalCity = $('#family_city_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalStreet = $('#family_street_editor').foxEditor().getValue();
	g_curAddrNoteInfo.personalPostCode = $('#family_postcode_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyName = $('#company_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyDept = $('#department_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyPosition = $('#position_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyCountry = $('#company_country_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyProvince = $('#company_province_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyCity = $('#company_city_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyStreet = $('#company_street_editor').foxEditor().getValue();
	g_curAddrNoteInfo.companyPostCode = $('#company_postcode_editor').foxEditor().getValue();
	g_curAddrNoteInfo.otherInfo = $('#other_editor').foxTextAreaEx().getValue();
}

function toggleToolbar(flag) {
	if (flag === 'person') {
		$('#toolbar').show();
		$('#info_buttons').show();
		$('#group_buttons').hide();
	} else if (flag === 'group') {
		$('#toolbar').show();
		$('#info_buttons').hide();
		$('#group_buttons').show();
	} else if (flag === 'none'){
		$('#toolbar').hide();
	}
}

function showNewAddrNote() {
	try {
		toggleToolbar('person');
		$('#delete_button').hide();
		doNewAddrNote();
		updateEditPanel(g_curAddrNoteInfo);
	} catch (e) {
		WriteLog('showNewAddrNote', e.message);
	}
}

function showNewGroup() {
	try {
		toggleToolbar('group');
		$('#group_delete_button').hide();
		doNewGroup();
		updateGroupEditPanel(g_curAddrNoteInfo);
	} catch (e) {
		WriteLog('showNewGroup', e.message);
	}
}

function updateGroupViewPanel(noteInfo) {
	toggleToolbar('none');
	GroupInitLanguage();
	var groupName = noteInfo.groupName;
	var noteid = noteInfo.noteid;
	GroupUpdateName(noteid, groupName);
	GroupListEmpty();
	var listCount = noteInfo.groupList.length;
	for (var i = 0; i < listCount; i++) {
		var info = noteInfo.groupList[i];
		var type = info.type;
		var name = info.name;
		var addr = info.addr;
		var id = info.id;
		GroupAddEmail(id, type, name, addr);
	}
	if (noteInfo.readOnly) $('#group_edit_button').hide();
	else $('#group_edit_button').show();
}

function doNewGroup() {
	g_curAddrNoteInfo = null;
	g_curAddrNoteInfo = {};
	g_curAddrNoteInfo.groupName = '';
	g_curAddrNoteInfo.groupList = [];
}

function updateGroupEditPanel(noteInfo) {
	toggleToolbar('group');
	GroupInitLanguage();

	var elGroupName = $('#group_edit_name');
	elGroupName.foxEditor().remove();
	var groupNameEditor = elGroupName.foxEditor();
	groupNameEditor.setDefaultValue(csGroupName);

	if (noteInfo.groupName === '') {
		groupNameEditor.setValue(csGroupName);
		groupNameEditor.setState(groupNameEditor.unChangeState);
		groupNameEditor.darken();
	} else {
		groupNameEditor.setValue(noteInfo.groupName);
		groupNameEditor.unDarken();
	}

	$('#group_list_container').empty();
	var listCount = noteInfo.groupList.length;
	for (var i = 0; i < listCount; i++) {
		var info = noteInfo.groupList[i];
		var type = info.type;
		var name = info.name;
		var id = info.id;
		GroupAddMemberToEdit(id, type, name);
	}
}

function updateEditPanel(noteInfo, editType) {
	function initPromptEditor(selector, prompt, value) {
		var editor = $(selector);
		editor.foxEditor().remove();
		var editor = editor.foxEditor();

		editor.setDefaultValue(prompt);
		if (value === '') {
			editor.setValue(prompt);
			editor.setState(editor.unChangeState);
			editor.darken();
		} else {
			editor.setValue(value);
			editor.unDarken();
		}
	}

	function initNonePromptEditor(selector, value) {
		var editor = $(selector);
		editor.foxEditor().remove();
		var editor = editor.foxEditor();
		editor.setValue(value);
	}

	function updateNameList() {
		var firstNameEditor = $('#first_name').foxEditor();
		var lastNameEditor = $('#last_name').foxEditor();
		var nickNameEditor = $('#nick_name').foxEditor();
		var nameSelector = $('#switch_display_name').foxListSelector();

		var firstName = firstNameEditor.getValue();
		var lastName = lastNameEditor.getValue();
		var nickName = nickNameEditor.getValue();

		if (firstNameEditor.getState() === firstNameEditor.unChangeState) firstName = '';
		if (lastNameEditor.getState() === lastNameEditor.unChangeState) lastName = '';
		if (nickNameEditor.getState() === nickNameEditor.unChangeState) nickName = '';
		if (firstName === '' && lastName === '' && nickName === '') {
			nameSelector.disable();
			return;
		}
		var list = getNameList(firstName, lastName, nickName);
		nameSelector.updateList(list);
		nameSelector.enable();

		var index1 = nameSelector.getIndex();
		var listLength = nameSelector.getListLength();
		var index2 = getNameListIndex(list, noteInfo.displayName);

		if (index1 >= 0 && index1 < listLength) nameSelector.select(index1);
		else if (index2 >= 0) nameSelector.select(index2);
		else nameSelector.select(0);
	}

	function updateEmailList(mainEmail, emails) {
		var editors = $('#email_list_editors ul');
		editors.empty();
		var buttons = $('#email_list_buttons ul');
		buttons.empty();

		if ((mainEmail !== undefined) && (mainEmail !== '')) {
			AddEmailAddressEditor(mainEmail, true, false, false);
		}
		for (var i = 0; i < emails.length; i++) {
			var email = emails[i];
			if ( email !== mainEmail ) {
				AddEmailAddressEditor(email, false, false, false);
			}
		}
		var lis = editors.find('li');
		if (lis.length > 0) {
			lis.first().find('input').addClass('text_input_bold');
		} else {
			AddEmailAddressEditor('', true, false, false);
		}

		editors.sortable({
			axis: 'y',
			items: 'li',
			placeholder: "email_editor_palceholder",
			// 字体加粗
			stop: function() {
				var inputs = editors.find('input');
				inputs.removeClass('text_input_bold');
				inputs.first().addClass('text_input_bold');
			}
		});
		editors.disableSelection();
	}
	
	try {
		toggleToolbar('person');
		
		$('#avatar_img').attr('src', noteInfo.avatar);

		initPromptEditor('#first_name', csFirstName, noteInfo.firstName);
		initPromptEditor('#last_name', csLastName, noteInfo.lastName);
		initPromptEditor('#nick_name', '', noteInfo.nickName);
		if (noteInfo.firstName === '' && noteInfo.lastName === '' && noteInfo.displayName !== '') {
			initPromptEditor('#last_name', csLastName, noteInfo.displayName);				
		}

		$('#first_name').foxEditor().onChange(updateNameList);
		$('#last_name').foxEditor().onChange(updateNameList);
		$('#nick_name').foxEditor().onChange(updateNameList);

		var nameSelector = $('#switch_display_name').foxListSelector();

		$('#switch_display_name').foxListSelector().remove();
		var nameSelector = $('#switch_display_name').foxListSelector();
		nameSelector.onDropdown(updateNameList);

		updateNameList();
		updateEmailList(noteInfo.mainEmail, noteInfo.emailList);

		//contact list
		$('#contact_list').empty();
		$('#contact_list').attr('faxNum', '0');
		$('#contact_list').attr('phoneNum', '0');
		AddMobileEditor(noteInfo.mobile);
		
		var bNoPhone = true;
		for (var i = 0; i < noteInfo.phoneList.length; i++) {
			var phone = noteInfo.phoneList[i];
			if (phone != '') {
				AddPhoneEditor(phone, false, null, false);
				bNoPhone = false;
			}
		}
		if (bNoPhone) {
			AddPhoneEditor('', false, null, false);
		}
		var bNoFax = true;
		for (var i = 0; i < noteInfo.faxList.length; i++) {
			var fax = noteInfo.faxList[i];
			if (fax != '') {
				AddFaxEditor(fax, false, null, false);
				bNoFax = false;
			}
		}
		if (bNoFax) {
			AddFaxEditor('', false, null, false);
		}

		// 性别选项框
		var elSexEditor = $('#sex_editor');
		var sexEditor = elSexEditor.foxCombobox();
		sexEditor.updateList(['', csSexMale, csSexFemale]);
		sexEditor.setValue(getSexString(noteInfo.sex));

		// 生日编辑框
		$('#birthday_editor').foxEditor().setValue(noteInfo.birthday);
		// editor.foxEditor().remove();
		// var editor = editor.foxEditor();
		// editor.setValue(value);
		// initNonePromptEditor('#birthday_editor', noteInfo.birthday);
		// QQ编辑框
		initNonePromptEditor('#qq_editor', noteInfo.qq);
		// 主页编辑框
		initNonePromptEditor('#homepage_editor', noteInfo.personalHomePage);
		// 家庭国家编辑框
		initPromptEditor('#family_country_editor', csCountry, noteInfo.personalCountry);
		// 家庭省编辑框
		initPromptEditor('#family_province_editor', csProvince, noteInfo.personalProvince);
		// 家庭市编辑框
		initPromptEditor('#family_city_editor', csCity, noteInfo.personalCity);
		// 家庭街道编辑框
		initPromptEditor('#family_street_editor', csStreet, noteInfo.personalStreet);
		// 家庭邮政编码编辑框
		initPromptEditor('#family_postcode_editor', csPostCode, noteInfo.personalPostCode);
		// 公司编辑框
		initNonePromptEditor('#company_editor', noteInfo.companyName);
		// 部门编辑框
		initNonePromptEditor('#department_editor', noteInfo.companyDept);
		// 职位编辑框
		initNonePromptEditor('#position_editor', noteInfo.companyPosition);
		// 公司国家编辑框
		initPromptEditor('#company_country_editor', csCountry, noteInfo.companyCountry);
		// 公司省编辑框
		initPromptEditor('#company_province_editor', csProvince, noteInfo.companyProvince);
		// 公司市编辑框
		initPromptEditor('#company_city_editor', csCity, noteInfo.companyCity);
		// 公司街道编辑框
		initPromptEditor('#company_street_editor', csStreet, noteInfo.companyStreet);
		// 公司邮政编码编辑框
		initPromptEditor('#company_postcode_editor', csPostCode, noteInfo.companyPostCode);
		//comment
		var other = $('#other_editor');
		other.foxTextAreaEx().remove();
		var otherEditor = other.foxTextAreaEx();
		function adjustOtherEditor() {
			if ($(document.activeElement).parents('#other_editor').length == 0) return;

			setTimeout( function() {
				AdjustFrameSize();
				var height = other.height();
				if ( (height + 100) < $(window).height()) {
					scrollPanel(other, $('#toolbar'), 5, 100);	
				} else {
					var scrollbar = getFoxWBScrollbar('scrollbar');
					var scrollbarHeight = scrollbar.vertScrollerTotalHeight();
					scrollbar.scrollVert(scrollbarHeight);
				}	
			}, 1);
		}
		otherEditor.bind('resize', adjustOtherEditor);
		otherEditor.setValue(noteInfo.otherInfo);

		if (editType == addrNoteTypeAdd) {
			$('#delete_button').hide();	
		} else if (editType == addrNoteTypeShowEdit) {
			$('#delete_button').show();
		}
		//AdjustFrameSize();
	} catch (e) {
		WriteLog('updateEditPanel', e.message);
	}
}

function updateViewPanel(noteInfo) {
	
	function updateValue(selector, value) {
		var el = $(selector);
		if (value === '') {
			el.parent().addClass('hide');
		} else {
			el.parent().removeClass('hide');
			el.html(value);
		}
	}

	function updateEmailList(mainEmail, emails) {
		var list = $('#view_panel_email_list');
		list.empty();

		if (mainEmail !== '') {
			list.append("<li type='email' email='"
				+ mainEmail +"'><span class='email_list_item'>"
				+ mainEmail + "</span><span class='related_mails_button'>"
				+ csRelatedEmails + "</span></li>");			
		}
		for (var i = 0; i < emails.length; i++) {
			var email = emails[i];

			if ((email !== '') && (email !== mainEmail)) {
				list.append("<li type='email' email='"
					+ email +"'><span class='email_list_item'>"
					+ email + "</span><span class='related_mails_button'>"
					+ csRelatedEmails + "</span></li>");
			}
		}
		var lis = list.find('li');
		if ( lis.length > 0 ) {
			lis.first().addClass('bold');
			list.parents('.view_panel_email_list').removeClass('hide');
		} else {
			list.parents('.view_panel_email_list').addClass('hide');
		}
	}

	//base info
	toggleToolbar('none');

	var avatar_url = noteInfo.avatar;
	avatar_url = avatar_url + '?hashkey=' + ((new Date()).getTime());
	$('#view_panel_avatar_img').attr('src', avatar_url);
	$('#avatar_img').attr('src', avatar_url);
	if (noteInfo.displayName) $('#view_panel_displayName').text(noteInfo.displayName);
	else {
		$('#view_panel_displayName').text(noteInfo.lastName + " " + noteInfo.firstName);
	}
	$('#view_panel_displayName').attr('noteid', noteInfo.noteid);
	// $('#view_panel_first_name').text(noteInfo.firstName);
	// $('#view_panel_last_name').text(noteInfo.lastName);
	var readOnly = noteInfo.readOnly;
	if (readOnly) {
		$('#view_panel_edit_button').hide();
	} else {
		$('#view_panel_edit_button').show();
	}

	updateEmailList(noteInfo.mainEmail, noteInfo.emailList);
	
	$('.view_panel_phone').addClass('hide');
	//隐藏全部
	var index = 1;
	for (var i = 0; i < noteInfo.phoneList.length; i++) {
		var phone = noteInfo.phoneList[i];
		if (phone != '') {
			$('#view_panel_phone_' + index).parent().removeClass('hide');
			$('#view_panel_phone_' + index).text(phone);
			index++;
		}
	}
	$('.view_panel_fax').addClass('hide');
	//隐藏全部
	index = 1;
	for (var i = 0; i < noteInfo.faxList.length; i++) {
		var phone = noteInfo.faxList[i];
		if (phone != '') {
			$('#view_panel_fax_' + index).parent().removeClass('hide');
			$('#view_panel_fax_' + index).text(phone);
			index++;
		}
	}
	//contact
	updateValue('#view_panel_mobile', noteInfo.mobile);
	updateValue('#view_panel_birthday', noteInfo.birthday);
	updateValue('#view_panel_nick', noteInfo.nickName);
	updateValue('#view_panel_sex', getSexString(noteInfo.sex));
	updateValue('#view_panel_qq', noteInfo.qq);
	updateValue('#view_panel_homepage', noteInfo.personalHomePage);
	
	var strArr = [];
	if (noteInfo.personalCountry) strArr.push(noteInfo.personalCountry);
	if (noteInfo.personalProvince) strArr.push(noteInfo.personalProvince);
	if (noteInfo.personalCity) strArr.push(noteInfo.personalCity);
	if (noteInfo.personalStreet) strArr.push(noteInfo.personalStreet);
	if (noteInfo.personalPostCode) strArr.push(noteInfo.personalPostCode);
	var homeAddress = strArr.join('&nbsp;&nbsp;&nbsp;');
	updateValue('#view_panel_address', homeAddress);

	updateValue('#view_panel_company', noteInfo.companyName);
	updateValue('#view_panel_dept', noteInfo.companyDept);
	updateValue('#view_panel_position', noteInfo.companyPosition);

	strArr = [];
	if (noteInfo.companyCountry) strArr.push(noteInfo.companyCountry);
	if (noteInfo.companyProvince) strArr.push(noteInfo.companyProvince);
	if (noteInfo.companyCity) strArr.push(noteInfo.companyCity);
	if (noteInfo.companyStreet) strArr.push(noteInfo.companyStreet);
	if (noteInfo.companyPostCode) strArr.push(noteInfo.companyPostCode);
	var workAddress = strArr.join('&nbsp;&nbsp;&nbsp;');
	updateValue('#view_panel_work_address', workAddress);

	//addrEcGroupList
	$('#view_panel_company_mail_group_ul').empty();
	var hasAddrEcGroupList = noteInfo.addrEcGroupList.hasEcGroupList;
	if (hasAddrEcGroupList) {
		var addrEcGroupUL = $('#view_panel_company_mail_group_ul');
		var addrEcGroupList = noteInfo.addrEcGroupList.addrEcGroupList;
		for (var i = 0; i < addrEcGroupList.length; i++) {
			var name = addrEcGroupList[i].name;
			var email = addrEcGroupList[i].email;
			var noteid = addrEcGroupList[i].noteid;
			//var str = "<li><span type='group' notedid='"+noteid+"'><div class='view_panel_company_mail_group_type'><div class='view_panel_company_mail_group_name'>" + name + "</div><div class='clear'></div></div></span></li>";
			var str = "<li noteid='" + noteid + "' name='" + name + "' email='" + email + "'><span class='view_panel_company_mail_group_name' type='group' noteid='"+noteid+"'><span class='view_panel_company_mail_group_type'></span><span>" + name + "</span></span></li>"
			$(str).appendTo(addrEcGroupUL);
		}
		$('#view_panel_company_mail_group').removeClass('hide');
	} else {
		$('#view_panel_company_mail_group').addClass('hide');
	}
	//other
	if (noteInfo.otherInfo === '') {
		$('#view_panel_other_info').parent().addClass('hide');
	} else {
		$('#view_panel_other_info').parent().removeClass('hide');
		$('#view_panel_other_info').html(noteInfo.otherInfo);
	}
	//
}

// Function call by Delphi

function initPage() {
	// 右键菜单
	$('#body_main').mouseup(function(ev) {
		// 不保证非IE浏览器有效
		if (ev.button === 2) {
			
			invokeAppFunction('PopupMainMenu', {
				x: ev.clientX,
				y: ev.clientY,
				show: false
			});
		}
	});

	document.body.attachEvent('onclick', function(event) {
		try {
			ToggleBirthdayCalendar(false);
			ToggleContactCard(null, false); 
		} catch (e) {
			WriteLog('document onclick', e.message);
		}
	});

	//
	// 快捷键
	//
	$(document).keydown(function(ev){
		try {
			if (ev.keyCode  == 13) {
				if (!$('#edit_panel').hasClass('hide')) {
					syncNoteInfo();
					var bRet = invokeAppFunction('syncNoteInfo', g_curAddrNoteInfo);
					if (bRet) $('#main').focus();		
				} else if (!$('#group_panel_edit').hasClass('hide')) {
					syncGroupInfo();
					var bRet = invokeAppFunction('SyncGroupInfo', g_curAddrNoteInfo);
					if (bRet) $('#main').focus();	
				}
			} else if (ev.keyCode == 27){
				var bRet = invokeAppFunction('OnCancel', {}); 				
				if (!$('#edit_panel').hasClass('hide')) {
					if (!bRet) {
						togglePanel(true, false, false, false, false, false);
						$('#main').focus();
					}
				} else if (!$('#group_panel_edit').hasClass('hide')) {
					if (!bRet) {
						invokeAppFunction('ClearTempSelMember', {});
						updateGroupViewPanel(g_curAddrNoteInfo);
						togglePanel(false, false, true, false, false, false);
						$('#main').focus();
					}
				}
			}	
		} catch (e) {
			WriteLog('document enter hot key', e.message);
		} 
    });
	
	//
	// 个人页面的
	//
	$('#view_panel_displayName').click(function(e) {
		if (document.selection.createRange().text !== '') 
			return;
		 
		var params = {};
		params.type = 'person';
		params.value = $(this).attr('noteid');
		invokeAppFunction('composeMail', params);
	});
	//
	// 个人页面的
	//
	$('#view_panel_email_list').delegate('.email_list_item', 'click', function(e) {
		if (document.selection.createRange().text !== '') 
			return;

		var email = $(this).parent().attr('email');
		var params = {};
		params.type = 'email';
		params.value = email;
		invokeAppFunction('composeMail', params);
	});
	$('#view_panel_email_list').delegate('.related_mails_button', 'click', function(e) {
		var email = $(this).parent().attr('email');
		var params = {};
		params.value = email;
		invokeAppFunction('findRelatedMails', params);
	});
	//
	// 个人页面的
	//
	$('#view_panel_company_mail_group_ul').delegate('.view_panel_company_mail_group_name', 'click', function(e) {
		if (document.selection.createRange().text !== '') 
			return;

		ToggleContactCard($(this).parents('li'), true);
		e.stopPropagation();
	});
	//
	// 用户组页面的
	//
	$('#group_name').click(function(e) {
		if (document.selection.createRange().text !== '') 
			return;

		var noteid = $(this).attr('noteid');
		var params = {};
		params.type = 'group';
		params.value = noteid;
		invokeAppFunction('composeMail', params);
	});
	//
	// 用户组页面的
	//
	$('#group_email_list').delegate('span', 'click', function(e) {
		if (document.selection.createRange().text !== '') 
			return;

		ToggleContactCard($(this).parents('li'), true);
		e.stopPropagation();
	});

	//bind edit button event
	$('#view_panel_edit_button').on('click', function() {
		updateEditPanel(g_curAddrNoteInfo);
		togglePanel(false, true, false, false, false, false);
	});

	function onCancel() {
		try {
			var bRet = invokeAppFunction('OnCancel', {});
			if (!bRet) {
				togglePanel(true, false, false, false, false, false);
			}
		} catch (e) {
			WriteLog('onCancel', e.message);	
		}
	}
	$('#cancel_button').on('click', onCancel);
	$('#cancel_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onCancel();
			ev.stopPropagation();
		}
	});

	function onSave() {
		try {
			syncNoteInfo();
			invokeAppFunction('syncNoteInfo', g_curAddrNoteInfo);
		} catch (e) {
			WriteLog('onSave', e.message);
		}		
	}
	$('#save_button').on('click', onSave);
	$('#save_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onSave();
			ev.stopPropagation();
		}
	});

	function onDelete() {
		try {
			var bCancel = invokeAppFunction('deleteAddrNote', {});
			if (!bCancel) {
				togglePanel(false, false, false, false, false, true);
			}
		} catch (e) {
			WriteLog('onDelete', e.message);
		}		
	}
	$('#delete_button').on('click', onDelete);
	$('#delete_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onDelete();
			ev.stopPropagation();
		}
	});

	//group
	$('#group_edit_button').on('click', function() {
		updateGroupEditPanel(g_curAddrNoteInfo);
		togglePanel(false, false, false, true, false, false);
	});
	$('#group_add_member_button').on('click', function() {
		try {
			var listString = invokeAppFunction('ShowSelMemberForm', {});
			var obj = parseJSON(listString);
			if (!obj.cancel) {
				//更新列表
				var members = obj.members;
				$('#group_list_container').empty();
				for (var i = 0; i < members.length; i++) {
					var id = members[i].id;
					var name = members[i].name;
					var type = members[i].type;
					GroupAddMemberToEdit(id, type, name);
				}
			}
			togglePanel(false, false, false, true, false, false);
			AdjustFrameSize();
		} catch (e) {
			WriteLog('Add member', e.message);
		}
	});
	$('#group_add_member_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			$('#group_add_member_button').click();
			ev.stopPropagation();
		}
	});

	function onGroupSave() {
		try {
			syncGroupInfo();
			var bRet = invokeAppFunction('SyncGroupInfo', g_curAddrNoteInfo);
			if (bRet) {
				updateGroupViewPanel(g_curAddrNoteInfo);
			} 
		} catch (e) {
			WriteLog('onGroupSave', e.message);
		}	
	}
	$('#group_save_button').on('click', onGroupSave);
	$('#group_save_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onGroupSave();
			ev.stopPropagation();
		}
	});

	function onGroupCancel() {
		try {
			var bRet = invokeAppFunction('OnCancel', {});
			if (!bRet) {
				invokeAppFunction('ClearTempSelMember', {});
				updateGroupViewPanel(g_curAddrNoteInfo);
				togglePanel(false, false, true, false, false, false);
			}		
		} catch (e) {
			WriteLog('onGroupCancel', e.message);
		}	
	}
	$('#group_cancel_button').on('click', onGroupCancel);
	$('#group_cancel_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onGroupCancel();
			ev.stopPropagation();
		}
	});

	function onGroupDelete() {
		try {
			var bCancel = invokeAppFunction('deleteAddrNote', {});
			if (!bCancel) {
				togglePanel(false, false, false, false, false, true);
			}
		} catch (e) {
			WriteLog('onGroupDelete', e.message);
		}		
	}
	$('#group_delete_button').on('click', onGroupDelete);
	$('#group_delete_button').keydown(function(ev) {
		if (event.keyCode == 13) {
			onGroupDelete();
			ev.stopPropagation();
		}
	});

	//plus minus button
	$(document).delegate('.plus_button', 'click', function(e) {
		var elemName = $(this).attr('name');
		if (elemName === 'add_email_address') {
			AddEmailAddressEditor('', false, true, true);
		} else if (elemName === 'add_contact_phone') {
			AddPhoneEditor('', true, CheckAddPhoneButton, true);
		} else if (elemName === 'add_contact_fax') {
			AddFaxEditor('', true, CheckAddFaxButton, true);
		}
	});
	$(document).delegate('.minus_button', 'click', function(e) {
		var elemName = $(this).attr('name');
		if (elemName === 'remove_email_address') {
			var liElem = $(this).parent();
			DoRemoveEmailAddressItem(liElem);
		} else if (elemName === 'remove_contact_phone') {
			var liElem = $(this).parent();
			DoRemoveContactPhoneItem(liElem, CheckAddPhoneButton);
		} else if (elemName === 'remove_contact_fax') {
			var liElem = $(this).parent();
			DoRemoveContactFaxItem(liElem, CheckAddFaxButton);
		} else if (elemName === 'remove_group_member') {
			var liElem = $(this).parent();
			var obj = $('input', liElem);
			var noteId = obj.attr('noteId');
			liElem.remove();
			invokeAppFunction('RemoveSelMember', {
				id: noteId
			});
			updateScrollbar();
		}
	});

	//
	$(document).delegate('#avatar', 'click', function(e) {
		try {
			var bReadOnly = g_curAddrNoteInfo.readOnly;
			if (!bReadOnly) {
				var avatar = invokeAppFunction('setAvatar', {});
				if (avatar === '') {
					//do nothing
				} else {
					$('#avatar_img').attr('src', avatar);
				}
			}
		} catch (e) {

		}
	});
	
	$(window).resize(function() {
		setTimeout(function(){
			AdjustFrameSize();
			var scrollbar = getFoxWBScrollbar('scrollbar');
			if (scrollbar) {
				scrollbar.update();
			}
		}, 1);
	});
	document.body.attachEvent('onmousewheel', function(event) {
		try {
			var val = event.wheelDelta;
			var scrollbar = getFoxWBScrollbar('scrollbar');
			if (scrollbar) {
				var cur = scrollbar.vertScrollTop();
				scrollbar.scrollVert(cur - val);
			}
		} catch (e) {
			WriteLog('onmousewheel', e.message);
		}
	});

	//calendar
	$('#birthday_editor').foxEditor().on('click', function(ev) {
		try {
			ToggleBirthdayCalendar(true);
			ev.stopPropagation();
			ev.preventDefault();
		} catch (e) {}
	});

	$('#birthday_button').on('click', function(e) {
		try {
			if ($(this).hasClass('calendar_button_press')) {
				ToggleBirthdayCalendar(false);
			} else {
				ToggleBirthdayCalendar(true);
			}

			e.stopPropagation();
		} catch (e) {
			WriteLog('calendar button', e.message);
		}
	});
	$(document).delegate('input', 'focus', function(e) {
		try {
			var obj = $(this);
			if (obj.parents('#birthday_editor').length == 0) {
				var toolbar = $('#toolbar');
				scrollPanel(obj, toolbar, 10, 20);
			}
		} catch (e) {
			WriteLog('focus edit', e.message);
		}
	});
	$(document).delegate('textarea', 'focus', function(e) {
		try {
			var obj = $(this);
			var toolbar = $('#toolbar');
			scrollPanel(obj, toolbar, 10, 20);
		} catch (e) {
			WriteLog('focus edit', e.message);
		}
	});
	
	$('body').bind('mousewheel',function() {
		if ($('#birthday_button').hasClass('calendar_button_press')) {
			ToggleBirthdayCalendar(false);
		}
	});
	$(document).delegate('.foxwb_scroller', 'mousedown', function() {
		if ($('#birthday_button').hasClass('calendar_button_press')) {
			ToggleBirthdayCalendar(false);
		}	
	});

	$('#other_editor').keydown(function(ev){
		ev.stopPropagation();
	});
	//
	setupFoxWBScrollbar();
	initFoxWBScrollbar();
	var scrollbar = createFoxWBScrollbar({
		id: 'scrollbar',
		Parent: 'main',
		VS: true,
		VSTarget: $('#body_main')
	});
}

function showMultiSelectedPanel(flag, count) {
	if (flag) {
		$('#multi_selected_count').text(csSelectedNotes.replace(/%s/, count));
		$('#multi_selected_panel').removeClass('hide');
	} else {
		$('#multi_selected_panel').addClass('hide');
	}
}
function showLogoPanel(flag) {
	if (flag) {
		$('#none_selected_panel').removeClass('hide');
	} else {
		$('#none_selected_panel').addClass('hide');
	}
}

//对应TAddrNoteShowType
var addrNoteTypeAdd = 0;
var addrNoteTypeShow = 1;
var addrNoteTypeShowEdit = 2;
var addrNoteTypeShowGroup = 3;
var addrNoteTypeShowGroupEdit = 4;
var addrNoteTypeNewGroup = 5;
var addrNoteTypeMultiSelected = 6;
var addrNoteTypeNoneSelected = 7;

function togglePanel(isView, isEdit, isGroupView, isGroupEdit, isSelect, isLogo, selectNum) {
	setTimeout(function(){
		clearTextSelection();
		if (isSelect || isLogo) {
			$('#body_main').addClass('hide');
			showLogoPanel(isLogo);
			showMultiSelectedPanel(isSelect, selectNum);		
		} else {
			$('#body_main').removeClass('hide');
			showViewPanel(isView);	
			showEditPanel(isEdit);
			showGroupViewPanel(isGroupView);
			showGroupEditPanel(isGroupEdit);			
		}
		
		AdjustFrameSize();
		getFoxWBScrollbar('scrollbar').scrollVert(0);
	}, 1);
}

function updateNoteInfo(params) {
	try {
		var jsonString = params.getValue('AddrNoteInfo');
		//var showEdit = params.getValue('showEdit');
		var showType = params.getValue('showType');
		g_curAddrNoteInfo = null;
		g_curAddrNoteInfo = parseJSON(jsonString);
		if (showType == addrNoteTypeNoneSelected) {
			togglePanel(false, false, false, false, false, true);
		} else if (showType == addrNoteTypeAdd) {
			if (g_curAddrNoteInfo) updateEditPanel(g_curAddrNoteInfo, addrNoteTypeAdd);
			else showNewAddrNote();
			togglePanel(false, true, false, false, false, false);
		} else if (showType == addrNoteTypeShow) {
			updateViewPanel(g_curAddrNoteInfo);
			togglePanel(true, false, false, false, false, false);
		} else if (showType == addrNoteTypeShowEdit) {
			updateEditPanel(g_curAddrNoteInfo, addrNoteTypeShowEdit);
			togglePanel(false, true, false, false, false, false);
		} else if (showType == addrNoteTypeShowGroup) {
			updateGroupViewPanel(g_curAddrNoteInfo);
			togglePanel(false, false, true, false, false, false);
		} else if (showType == addrNoteTypeShowGroupEdit) {
			updateGroupEditPanel(g_curAddrNoteInfo);
			togglePanel(false, false, false, true, false, false);
		} else if (showType == addrNoteTypeNewGroup) {
			showNewGroup();
			togglePanel(false, false, false, true, false, false);
		} else if (showType == addrNoteTypeMultiSelected) {
			togglePanel(false, false, false, false, true, false, g_curAddrNoteInfo.count);
		}
	} catch (e) {
		WriteLog('updateNoteInfo', e.message);
	}
}

function updateBirthDay(params) {
	try {
		var str = params.getValue('birthday');
		var type = params.getValue('type');
		
		$('#birthday_editor').foxEditor().setValue(str);
		if (type == 'dbclick') {
			ToggleBirthdayCalendar(false);
		}
	} catch (e) {
		WriteLog('updateBirthday', e.message);
	}
}

//
// 保存检查后的光标定位，由Delphi调用
//
function setFocus(params) {
	try {
		var place = params.getValue('place');
		if (place === 'email') {
			var editor = $('#email_list_editors .foxMailAddrEditor').foxMailAddrEditor();
			editor.setFocus();
			editor.setValue(editor.getValue());
		} else if (place === 'groupName')  {
			var editor = $('#group_edit_name').foxEditor();
			editor.setFocus();
			editor.setValue(editor.getValue());
		} else if (place === 'lastName')  {
			var editor = $('#last_name').foxEditor();
			editor.setFocus();
			editor.setValue(editor.getValue());
		}
	} catch (e) {
		WriteLog('updateBirthday', e.message);
	}	
}

function clearTextSelection() {
	function getSelText() {
		var txt = '';
		if (window.getSelection) {
			txt = window.getSelection();
		} else if (document.getSelection) {
			txt = document.getSelection();
		} else if (document.selection) {
			txt = document.selection;
		}
		return txt;
	}

	var sel = getSelText();
	if (sel) {
		if (sel.removeAllRanges) {
			sel.removeAllRanges();
		} else if (sel.empty) {
			sel.empty();
		}
	}	
}